/******************************************************************************
*
* @file    hsi16_calibration.c
* @author  ECS, Joseph Zimmer
* @version V1.0.0
* @date    06-05-2019
* @brief       
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "hsi16_calibration.h"
#include "hsi16.h"
#include "main.h"
#include <stdio.h>
//	--- EXTERNE VARIABLEN -------------------------------------------------------- 
extern int32_t  aFrequenceChangeTable[128];

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define GET_HSI16_TRIMMING_VALUE()              ((RCC->ICSCR & RCC_ICSCR_HSITRIM) >> 8)	
#define ABS_RETURN(x)         			((x < 0) ? (-x) : (x))
//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------
static uint8_t trimmingValueOrder[128];
static uint8_t selectTrimingValue;
//	--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

/*
* @brief
* @param	kein
* @retval	kein
*/

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void orderTrimmingValues(void)
{
  uint32_t x, y, z, a = 0;
  int32_t actualValue;
   
  for(x = 0; x < 128; x ++)
  {    
    actualValue = aFrequenceChangeTable[x];
    z = 0;
    for(y = 0; y < 128; y ++)
    {
      if(actualValue > aFrequenceChangeTable[y])
      {
        z ++;
      }
    }
    trimmingValueOrder[z] = x;
    if(trimmingValueOrder[z] == 0)
    {
      if(a == 1)
      {
        printf("ERROR TRIMMING VALUES\n");
        while(1);
      }
      a = 1;
    }
  }
  // auf standartwert setzen
  selectTrimingValue = 64;
  for(x = 0; x < 128; x ++)
  {
    #ifdef PRINT_FREQUENCY_MEASURE_RESULT
    printf("%3d;  %d\n", x, trimmingValueOrder[x]);
    #endif
    if(selectTrimingValue == trimmingValueOrder[x])
    {
      selectTrimingValue = x;
    }
  }
}

void HSI16_CALIBRATION_Process(void)
{
  uint32_t output = 0;
  uint32_t frequency = 0;
  uint32_t x;

  // Frequenz messen
  output = HSI16_FreqMeasure();
  if(output != 2)
  {
    frequency = output;
  }
  else
  {
    return;
  }
  
  // Gr0er oder kleiner 16MegHz
  if(frequency > 16050000) 
  {
    #ifdef PRINT_FREQUENCY_MEASURE_RESULT
    printf("HSI16 value too high\n");
    #endif
    selectTrimingValue --;
    // Frequenz anpassen
    __HAL_RCC_HSI_CALIBRATIONVALUE_ADJUST(trimmingValueOrder[selectTrimingValue]); 
  }
  else if(frequency < 15950000) 
  {
    #ifdef PRINT_FREQUENCY_MEASURE_RESULT
    printf("HSI16 value too low\n");
    #endif
    selectTrimingValue ++;
    // Frequenz anpassen
    __HAL_RCC_HSI_CALIBRATIONVALUE_ADJUST(trimmingValueOrder[selectTrimingValue]); 
  }
 
  #ifdef CHECK_CHANGED_FREQUENCY
  // neue Frequenz messen fr debugzwecke
  output = 2;
  while(output == 2)
  {
    output = HSI16_FreqMeasure();
  }
  printf("neue Frequenz = %d\n", output); 
  #endif
}
/*************************** End of file ****************************/